<?php
/*
 * bizzbeepro Breadcrumbs
*/
function bizzbeepro_custom_breadcrumbs() {

  $bizzbeepro_showonhome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
  $bizzbeepro_delimiter = '/'; // bizzbeepro_delimiter between crumbs
  $bizzbeepro_home = __('Home','bizzbeepro'); // text for the 'Home' link
  $bizzbeepro_showcurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
  $bizzbeepro_before = ' '; // tag before the current crumb
  $bizzbeepro_after = ' '; // tag after the current crumb

  global $post;
  $bizzbeepro_homelink = esc_url(home_url('/'));

  if (is_home() || is_front_page()) {

    if ($bizzbeepro_showonhome == 1) echo '<li id="breadcrumbs"><a href="' . $bizzbeepro_homelink . '">' . $bizzbeepro_home . '</a></li>';
    
  }  else {

    echo '<li id="breadcrumbs_home"><a href="' . $bizzbeepro_homelink . '">' . $bizzbeepro_home . '</a> </li><li id="breadcrumbs">';
    
   if ( is_category() ) {
      $bizzbeepro_thisCat = get_category(get_query_var('cat'), false);
      if ($bizzbeepro_thisCat->parent != 0) echo get_category_parents($bizzbeepro_thisCat->parent, TRUE, ' ' . $bizzbeepro_delimiter . ' ');      
		echo $bizzbeepro_before; _e('category','bizzbeepro'); echo ' "'.single_cat_title('', false) . '"' . $bizzbeepro_after;
    } 
    elseif ( is_search() ) {
      echo $bizzbeepro_before; _e('Search Results For','bizzbeepro'); echo ' "'. get_search_query() . '"' . $bizzbeepro_after;

    } elseif ( is_day() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $bizzbeepro_delimiter . ' ';
      echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $bizzbeepro_delimiter . ' ';
      echo $bizzbeepro_before . get_the_time('d') . $bizzbeepro_after;

    } elseif ( is_month() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $bizzbeepro_delimiter . ' ';
      echo $bizzbeepro_before . get_the_time('F') . $bizzbeepro_after;

    } elseif ( is_year() ) {
      echo $bizzbeepro_before . get_the_time('Y') . $bizzbeepro_after;

    } elseif ( is_single() && !is_attachment() ) {
      if ( get_post_type() != 'post' ) {
        $bizzbeepro_post_type = get_post_type_object(get_post_type());
        $bizzbeepro_slug = $bizzbeepro_post_type->rewrite;
        echo '<a href="' . $bizzbeepro_homelink . '/' . $bizzbeepro_slug['slug'] . '/">' . $bizzbeepro_post_type->labels->singular_name . '</a>';
        if ($bizzbeepro_showcurrent == 1) echo ' ' . $bizzbeepro_delimiter . ' ' . $bizzbeepro_before . get_the_title() . $bizzbeepro_after;
      } else {
        $bizzbeepro_cat = get_the_category(); $bizzbeepro_cat = $bizzbeepro_cat[0];
        $bizzbeepro_cats = get_category_parents($bizzbeepro_cat, TRUE, ' ' . $bizzbeepro_delimiter . ' ');
        if ($bizzbeepro_showcurrent == 0) $bizzbeepro_cats = preg_replace("#^(.+)\s$bizzbeepro_delimiter\s$#", "$1", $bizzbeepro_cats);
        echo $bizzbeepro_cats;
        if ($bizzbeepro_showcurrent == 1) echo $bizzbeepro_before . get_the_title() . $bizzbeepro_after;
      }

    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $bizzbeepro_post_type = get_post_type_object(get_post_type());
      echo $bizzbeepro_before . $bizzbeepro_post_type->labels->singular_name . $bizzbeepro_after;

    } elseif ( is_attachment() ) {
      $bizzbeepro_cat = get_the_category();
      $bizzbeepro_parent = get_post($post->post_parent);
      $bizzbeepro_cat = get_the_category($bizzbeepro_parent->ID); $bizzbeepro_cat = $bizzbeepro_cat[0];
      if(isset($bizzbeepro_cat) && !empty($bizzbeepro_cat)) { echo get_category_parents($bizzbeepro_cat, TRUE, ' ' . $bizzbeepro_delimiter . ' '); }
      echo '<a href="' . get_permalink($bizzbeepro_parent) . '">' . $bizzbeepro_parent->post_title . '</a>';
      if ($bizzbeepro_showcurrent == 1) echo ' ' . $bizzbeepro_delimiter . ' ' . $bizzbeepro_before . get_the_title() . $bizzbeepro_after;

    } elseif ( is_page() && !$post->post_parent ) {
      if ($bizzbeepro_showcurrent == 1) echo $bizzbeepro_before . get_the_title() . $bizzbeepro_after;

    } elseif ( is_page() && $post->post_parent ) {
      $bizzbeepro_parent_id  = $post->post_parent;
      $bizzbeepro_breadcrumbs = array();
      while ($bizzbeepro_parent_id) {
        $bizzbeepro_page = get_page($bizzbeepro_parent_id);
        $bizzbeepro_breadcrumbs[] = '<a href="' . get_permalink($bizzbeepro_page->ID) . '">' . get_the_title($bizzbeepro_page->ID) . '</a>';
        $bizzbeepro_parent_id  = $bizzbeepro_page->post_parent;
      }
      $bizzbeepro_breadcrumbs = array_reverse($bizzbeepro_breadcrumbs);
      for ($bizzbeepro_i = 0; $bizzbeepro_i < count($bizzbeepro_breadcrumbs); $bizzbeepro_i++) {
        echo $bizzbeepro_breadcrumbs[$bizzbeepro_i];
        if ($bizzbeepro_i != count($bizzbeepro_breadcrumbs)-1) echo ' ' . $bizzbeepro_delimiter . ' ';
      }
      if ($bizzbeepro_showcurrent == 1) echo ' ' . $bizzbeepro_delimiter . ' ' . $bizzbeepro_before . get_the_title() . $bizzbeepro_after;

    } elseif ( is_tag() ) {
      echo $bizzbeepro_before; _e('Posts tagged','bizzbeepro'); echo ' "'.  single_tag_title('', false) . '"' . $bizzbeepro_after;

    } elseif ( is_author() ) {
       global $author;
      $bizzbeepro_userdata = get_userdata($author);
      echo $bizzbeepro_before; _e('Articles posted by ','bizzbeepro'); echo $bizzbeepro_userdata->display_name . $bizzbeepro_after;

    } elseif ( is_404() ) {
      echo $bizzbeepro_before; _e('Error 404','bizzbeepro'); echo $bizzbeepro_after;
    }
    
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page','bizzbeepro') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
    echo '</li>';

  }
} // end bizzbeepro_custom_breadcrumbs()
