<?php
/*
 * thumbnail list
 */

function bizzbeepro_thumbnail_image($content) {

  if (has_post_thumbnail())
    return the_post_thumbnail('thumbnail');
}

/*
 * bizzbeepro Main Sidebar
 */

function bizzbeepro_widgets_init() {

  register_sidebar(array(
      'name' => __('Main Sidebar', 'bizzbeepro'),
      'id' => 'sidebar-1',
      'description' => __('Main sidebar that appears on the right.', 'bizzbeepro'),
      'before_widget' => '<div class="sidebar-widget %2$s" id="%1$s" >',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));

  register_sidebar(array(
      'name' => __('Footer area one', 'bizzbeepro'),
      'id' => 'footer-1',
      'description' => __('Footer area one that appears on the footer.', 'bizzbeepro'),
      'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));

  register_sidebar(array(
      'name' => __('Footer area two', 'bizzbeepro'),
      'id' => 'footer-2',
      'description' => __('Footer area two that appears on the footer.', 'bizzbeepro'),
      'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));

  register_sidebar(array(
      'name' => __('Footer area three', 'bizzbeepro'),
      'id' => 'footer-3',
      'description' => __('Footer area three that appears on the footer.', 'bizzbeepro'),
      'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));

  register_sidebar(array(
      'name' => __('Footer area four', 'bizzbeepro'),
      'id' => 'footer-4',
      'description' => __('Footer area four that appears on the footer.', 'bizzbeepro'),
      'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));
  register_sidebar(array(
      'name' => __('Footer area five', 'bizzbeepro'),
      'id' => 'footer-5',
      'description' => __('Footer area five that appears on the footer.', 'bizzbeepro'),
      'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
      'after_widget' => '</div>',
      'before_title' => '<h4 class="widget-title">',
      'after_title' => '</h4>',
  ));
}

add_action('widgets_init', 'bizzbeepro_widgets_init');

/*
 * bizzbeepro Set up post entry meta.
 *
 * Meta information for current post: categories, tags, permalink, author, and date.
 */

function bizzbeepro_entry_meta() {
  $bizzbeepro_categories_list = get_the_category_list(', ', ' ');
  $bizzbeepro_tag_list = get_the_tag_list('', ',');
  $bizzbeepro_author = get_the_author();
  $bizzbeepro_author_url = esc_url(get_author_posts_url(get_the_author_meta('ID')));
  $bizzbeepro_comments = wp_count_comments(get_the_ID());
  $bizzbeepro_date = sprintf('<time datetime="%1$s">%2$s</time>', sanitize_text_field(get_the_date('c')), esc_html(get_the_date())
  );
  ?>	
<div class="post-meta">
  <ul>
    <li><?php echo $bizzbeepro_date; ?></li>
    <li><?php echo _e('By :  ','bizzbeepro');?><a href="<?php echo $bizzbeepro_author_url; ?>" rel="tag"><?php echo $bizzbeepro_author; ?></a></li>		
    <?php if(!empty($bizzbeepro_tag_list)) { ?>				
    <li class="tag-list"><?php echo _e('Tags : ','bizzbeepro'). $bizzbeepro_tag_list; ?></li>
    <?php } ?>
    <?php if(!empty($bizzbeepro_categories_list)) { ?>				
	    <li class="category-list"><?php echo _e('Posted in : ','bizzbeepro').  $bizzbeepro_categories_list; ?></li>
    <?php } ?>
    <li><?php comments_number(__('No Comments', 'bizzbeepro'), __('1 Comment', 'bizzbeepro'), __('% Comments', 'bizzbeepro')); ?></li>
  </ul>
</div>                                        
  <?php
}

/*
 * pagination
 * */

function bizzbeepro_pagination() {
	if(is_single()){
		the_post_navigation( array(
			'prev_text' => '<div class="bizzbeepro_previous_pagination alignleft">%title</div>',
			'next_text' => '<div class="bizzbeepro_next_pagination alignright">%title</div>',
		) );
	}else{
		the_posts_pagination(array(
		  'prev_text' => '<i class="fa fa-angle-double-left"></i>',
		  'next_text' => '<i class="fa fa-angle-double-right"></i>',
		  'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
		));
	}
}

/*
 * Comments placeholder function
 * 
 * */
add_filter('comment_form_default_fields', 'bizzbeepro_comment_placeholders');

function bizzbeepro_comment_placeholders($fields) {
  $fields['author'] = str_replace(
          '<input', '<input placeholder="'
          . _x(
                  'Name *', 'comment form placeholder', 'bizzbeepro'
          )
          . '" required', $fields['author']
  );
  $fields['email'] = str_replace(
          '<input', '<input placeholder="'
          . _x(
                  'E-mail *', 'comment form placeholder', 'bizzbeepro'
          )
          . '" required', $fields['email']
  );
    $fields['url'] = str_replace(
          '<input', '<input placeholder="'
          . _x(
                  'Website *', 'comment form placeholder', 'bizzbeepro'
          )
          . '" required', $fields['url']
  );
  return $fields;
}

add_filter('comment_form_defaults', 'bizzbeepro_textarea_insert');

function bizzbeepro_textarea_insert($fields) {
  $fields['comment_field'] = str_replace(
          '<textarea', '<textarea  placeholder="'
          . _x(
                  'Comment', 'comment form placeholder', 'bizzbeepro'
          )
          . '" ', $fields['comment_field']
  );
  return $fields;
}
?>
