<?php
/**
 * The Header template file
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
  <head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <meta name="description" content="description" />
    <!--[if lt IE 9]>
	    <script src="<?php echo esc_url(get_template_directory_uri()); ?>/js/html5.js"></script>
    <![endif]-->
    <?php wp_head(); ?>
<style>
	<?php 
	$bizzbeepro_font = get_theme_mod( 'bizzbeepro_font' ); 
	if(!empty($bizzbeepro_font)) { ?>
	body {
			<?php if($bizzbeepro_font == 'electrolize') { ?>    
			font-family: 'Electrolize', sans-serif !important;    
			<?php } elseif($bizzbeepro_font == 'lato') { ?>
			font-family: 'Lato', sans-serif !important;
			<?php } elseif($bizzbeepro_font == 'ubuntu') { ?>
			font-family: 'Ubuntu', sans-serif !important;	
			<?php } elseif($bizzbeepro_font == 'prociono') { ?>
			font-family: 'Prociono', serif !important;	
			<?php } elseif($bizzbeepro_font == 'roboto') { ?>
			font-family: 'Roboto', sans-serif !important;
			<?php } ?>
		} 
		<?php } ?>

	</style>  
  </head>

  <body <?php body_class(); ?>>       
    <header class="inner-header">
	   <div class="container theme-container">
		  <div class="row">	
     
               <div class="col-md-2 col-sm-2 header-logo">   
				   <?php  if ( get_theme_mod( 'bizzbeepro_logo' ) ) { ?>
							<a href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'><img src='<?php echo esc_url( get_theme_mod( 'bizzbeepro_logo' ) ); ?>' alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' class="img-responsive"></a>
                        <?php } else { ?>
                            <a href="<?php echo esc_url(home_url('/')); ?>">
									<h3 class="site-title logo-box"><?php bloginfo( 'name' ); ?></h3>
									<h5 class="site-description"><?php bloginfo( 'description' ); ?></h5>
                            </a>
                        <?php }  ?>
				        </div>  
                                            
                <div class="col-md-10 col-sm-10 header-menu">               
                  <nav id="main-menu">
					  <div id="dt-menu-toggle" class="dt-menu-toggle">
						  <?php _e('Menu','bizzbeepro'); ?>
						 <span class="dt-menu-toggle-icon"></span>
					  </div>  
                    <?php
                    if (has_nav_menu('primary')) {
                      $bizzbeepro_defaults = array(
                          'theme_location' => 'primary',
                          'container' => '',
                          'container_class' => 'collapse navbar-collapse nav_coll',
                          'container_id' => 'example-navbar-collapse',
                          'menu_class' => 'overline',
                          'menu_id' => '',
                          'submenu_class' => '',
                          'echo' => true,
                          'before' => '',
                          'after' => '',
                          'link_before' => '',
                          'link_after' => '',
                          'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                          'depth' => 0
                      );
                      wp_nav_menu($bizzbeepro_defaults);
                    }
                    ?>                                                
                  </nav>	             
                </div>
     
		  </div>	
      </div>	
   </header>
    <?php
    $bizzbeepro_header_image = get_header_image();
    if (!empty($bizzbeepro_header_image)) {
      ?>
      <div class="webpage-container container custom-header">
        <img src="<?php echo esc_url($bizzbeepro_header_image); ?>" class="header-image img-responsive" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="<?php _e('custom-header', 'bizzbeepro') ?>" />
      </div>
    <?php } ?>
