<?php
function bizzbeepro_theme_customizer( $wp_customize ) {
    /* sections */
    $wp_customize->add_section( 'bizzbeepro_basic_section' , array(
    'title'       => __( 'Basic Settings', 'bizzbeepro' ),
    'priority'    => 30,
	) );
        
	
	$wp_customize->add_panel( 'home_id', array(
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __('Home Page Settings','bizzbeepro'),
		'description'    => '',
		'priority'    => 30,
	) );
    $wp_customize->add_section( 'bizzbeepro_blogpage_section' , array(
    'title'       => __( 'Blog Page Settings', 'bizzbeepro' ),
    'priority'    => 30,
	) );
    $wp_customize->add_section( 'bizzbeepro_contactpage_section' , array(
    'title'       => __( 'Contact Page Settings', 'bizzbeepro' ),
    'priority'    => 30,
	) );

	$wp_customize->add_section( 'bizzbeepro_silder_section' , array(
		'title'       => __( 'Slider Section', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );
	$wp_customize->add_section( 'bizzbeepro_welcome_section' , array(
		'title'       => __( 'Welcome To bizzbee', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );
	$wp_customize->add_section( 'bizzbeepro_perfection_section' , array(
		'title'       => __( 'Our path to Perfection', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );
	$wp_customize->add_section( 'bizzbeepro_ourteam_section' , array(
		'title'       => __( 'Our Team', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );

	$wp_customize->add_section( 'bizzbeepro_testimonial_section' , array(
		'title'       => __( 'Testimonials', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );

	$wp_customize->add_section( 'bizzbeepro_portfolio_section' , array(
		'title'       => __( 'Portfolio', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );

	$wp_customize->add_section( 'bizzbeepro_whatyouget_section' , array(
		'title'       => __( 'What You Get', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );
	$wp_customize->add_section( 'bizzbeepro_whoweare_section' , array(
		'title'       => __( 'Who we are', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );

	$wp_customize->add_section( 'bizzbeepro_blog_section' , array(
		'title'       => __( 'Blog Section', 'bizzbeepro' ),
		'priority'    => 30,
		'panel'  => 'home_id',
	) );

	/* basic section */
	/*theme logo*/
	$wp_customize->add_setting('bizzbeepro_color', array(
        'default' => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'bizzbeepro_color',
			array(
				'label' => __('Theme Color','bizzbeepro'),
				'section' => 'bizzbeepro_basic_section',
				'settings' => 'bizzbeepro_color',
			)
		)
	);	

	$wp_customize->add_setting('bizzbeepro_hover_color', array(
        'default' => '#82b440',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'bizzbeepro_hover_color',
			array(
				'label' => __('Theme Hover Color','bizzbeepro'),
				'section' => 'bizzbeepro_basic_section',
				'settings' => 'bizzbeepro_hover_color',
			)
		)
	);	

	$wp_customize->add_setting('bizzbeepro_font', array(
        'default'        => 'opensans',
		 'type' => 'theme_mod',
    ));

    $wp_customize->add_control('bizzbeepro_font', array(
		'label'    => __( 'Please Select theme font.', 'bizzbeepro' ),	
        'section'    => 'bizzbeepro_basic_section',
        'settings'   => 'bizzbeepro_font',
        'type'       => 'radio',
        'choices'    => array(
            'opensans' => 'Open Sans',
            'electrolize' => 'Electrolize',
            'lato' => 'Lato',
            'ubuntu' => 'Ubuntu',
            'prociono' => 'Prociono',
            'roboto' => 'Roboto',
        ),
    ));
	$wp_customize->add_setting( 'bizzbeepro_logo' ,array(
		'sanitize_callback' => 'esc_attr',
		)
	 );
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_logo', array(
		'label'    => __( 'Logo (Recommended size 220 x 120)', 'bizzbeepro' ),
		'section'  => 'bizzbeepro_basic_section',
		'settings' => 'bizzbeepro_logo',
	) ) );
	$wp_customize->add_setting('portfolio_column', array(
        'default'        => '3',
        'capability'     => 'edit_theme_options',
		 'type' => 'theme_mod',
    ));

    $wp_customize->add_control('portfolio_column', array(
		'label'    => __( 'Portfolio Page layout Option', 'bizzbeepro' ),	
        'section'    => 'bizzbeepro_basic_section',
        'settings'   => 'portfolio_column',
        'type'       => 'radio',
        'choices'    => array(
            '3' => '3 Column',
            '4' => '4 Colummn',
        ),
    ));
	// favicon
	$wp_customize->add_setting( 'bizzbeepro_favicon',array(
		'sanitize_callback' => 'esc_attr',
		)
	 );
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_favicon', array(
    'label'    => __( 'Favicon (Recommended size 32 x 32)', 'bizzbeepro' ),
    'section'  => 'bizzbeepro_basic_section',
    'settings' => 'bizzbeepro_favicon',
	) ) );
	

	// blog title
	$wp_customize->add_setting( 'bizzbeepro_blogtitle', array(
            'default'        => ' ',
            'sanitize_callback' => 'bizzbeepro_sanitize_text',
        ) );
   $wp_customize->add_control( 'bizzbeepro_blogtitle', array(
		'label'   => __('Blog Title','bizzbeepro'),
		'section' => 'bizzbeepro_basic_section',
		'type'    => 'text',
        ) );

	// copyright
	$wp_customize->add_setting( 'copyright_url_setting', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_html',
	) );
	$wp_customize->add_control( 'copyright_url_setting', array(
		'label'   => __('Copyright text','bizzbeepro'),
		'section' => 'bizzbeepro_basic_section',
		'type'    => 'text'
	) );

	//Powerby by
	$wp_customize->add_setting( 'power_by_text', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_html',
	) );
	$wp_customize->add_control( 'power_by_text', array(
		'label'   => __('Remove Credits','bizzbeepro'),
		'section' => 'bizzbeepro_basic_section',
		'type'    => 'checkbox'
	) );

	//Blog Page
	$wp_customize->add_setting('fullwidth_blog', array(
		'default'    => '1',
		'type'=>'theme_mod',
	));
	
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'fullwidth_blog',
			array(
				'label'     => __('Turn the blog into full width.', 'bizzbeepro'),
				'section'   => 'bizzbeepro_blogpage_section',
				'settings'  => 'fullwidth_blog',
				'type'      => 'checkbox',
			)
		)
	);	 

	$wp_customize->add_setting('sidebar_position', array(
        'default'        => 'right',
		 'type' => 'theme_mod',
    ));

    $wp_customize->add_control('sidebar_position', array(
		'label'    => __( 'Sidebar Position', 'bizzbeepro' ),	
        'section'    => 'bizzbeepro_blogpage_section',
        'settings'   => 'sidebar_position',
        'type'       => 'radio',
        'choices'    => array(
            'right' => __('Right Sidebar','bizzbeepro'),
            'left' => __('Left Sidebar','bizzbeepro'),
        ),
    ));
	$wp_customize->add_setting('excerpt_length', array(
        'default'        => '60',
		 'type' => 'theme_mod',
    ));

	$wp_customize->add_control( 'excerpt_length', array(
		'type' => 'number',
		'section' => 'bizzbeepro_blogpage_section',
		'label' => __( 'Excerpt Length','bizzbeepro' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
		),
	) );

	//Contact Page
	$wp_customize->add_setting( 'bizzbeepro_contact_mapurl', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_url',
	) );
    $wp_customize->add_control( 'bizzbeepro_contact_mapurl', array(
		'label'   => __('Map Url','bizzbeepro'),
		'section' => 'bizzbeepro_contactpage_section',
		'type'    => 'text',
    ) );
	$wp_customize->add_setting( 'bizzbeepro_contact_title', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_text',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_title', array(
			'label'   => __('Title','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'text',
           
        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_info', array(
            'default'        => '',
            'sanitize_callback' => '',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_info', array(
			'label'   => __('Description','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'textarea',
           
        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_address', array(
            'default'        => '',
            'sanitize_callback' => '',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_address', array(
			'label'   => __('Address 1','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'textarea',
           
        ) );
		    $wp_customize->add_setting( 'bizzbeepro_contact_address2', array(
		            'default'        => '',
		            'sanitize_callback' => '',
					'type' => 'theme_mod',
		        ) );
		    $wp_customize->add_control( 'bizzbeepro_contact_address2', array(
					'label'   => __('Address 2','bizzbeepro'),
		            'section' => 'bizzbeepro_contactpage_section',
		            'type'    => 'textarea',
		           
		        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_phone', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_text',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_phone', array(
			'label'   => __('Phone',''),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'text',
        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_fax', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_text',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_fax', array(
			'label'   => __('Fax','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'text',
        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_email', array(
            'default'        => '',
            'sanitize_callback' => '',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_email', array(
			'label'   => __('Email','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'text',
        ) );  	
	$wp_customize->add_setting( 'bizzbeepro_contact_web', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_url',
			'type' => 'theme_mod',
        ) );
    $wp_customize->add_control( 'bizzbeepro_contact_web', array(
			'label'   => __('Website','bizzbeepro'),
            'section' => 'bizzbeepro_contactpage_section',
            'type'    => 'text',
        ) );  	
		
	// home page	
	$wp_customize->add_setting( 'bizzbeepro_metaslider', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_number_absint',
        ) );
    $wp_customize->add_control( 'bizzbeepro_metaslider', array(
			'label'   => __('Meta Slider Id','bizzbeepro'),
            'section' => 'bizzbeepro_silder_section',
            'type'    => 'number',
           
        ) );  
       
     // Welcome Section  
  $wp_customize->add_setting('show_welcome_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_welcome_section', array(
        'settings' => 'show_welcome_section',
        'label'   => __('Select Something:','bizzbeepro'),
        'section' => 'bizzbeepro_welcome_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => __('Enable','bizzbeepro'),
            '2'=> __('Disable','bizzbeepro'),
        ),
    ));	 
     $wp_customize->add_setting( 'bizzbeepro_Welcome_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_title', array(
		'label'   => __('Welcome Title','bizzbeepro'),
		'section' => 'bizzbeepro_welcome_section',
		'type'    => 'text',
    ) );
    $wp_customize->add_setting( 'bizzbeepro_Welcome_info', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_info', array(
		'label'   => __('Welcome Info','bizzbeepro'),
        'section' => 'bizzbeepro_welcome_section',
        'type'    => 'textarea',
   ) );
   $wp_customize->add_setting( 'bizzbeepro_Welcome_righttitle', array(
		'default'        => '',
		'sanitize_callback' => 'esc_attr',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_righttitle', array(
		'label'   => __('Welcome Right Title','bizzbeepro'),
		'section' => 'bizzbeepro_welcome_section',
		'type'    => 'text',
    ) );
    $wp_customize->add_setting( 'bizzbeepro_Welcome_rightinfo', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_rightinfo', array(
		'label'   => __('Welcome Right Info','bizzbeepro'),
        'section' => 'bizzbeepro_welcome_section',
        'type'    => 'textarea',
   ) );     
   $wp_customize->add_setting( 'bizzbeepro_Welcome_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_Welcome_image_bg', array(
			'label'    => __( 'Center Image (Recommended size 570 x 350)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_welcome_section',
			'settings' => 'bizzbeepro_Welcome_image_bg',
		) 
	) ); 
   
     $wp_customize->add_setting( 'bizzbeepro_Welcome_lefttitle', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_lefttitle', array(
		'label'   => __('Welcome Left Title','bizzbeepro'),
		'section' => 'bizzbeepro_welcome_section',
		'type'    => 'text',
    ) );
    $wp_customize->add_setting( 'bizzbeepro_Welcome_leftinfo', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_Welcome_leftinfo', array(
		'label'   => __('Welcome Left Info','bizzbeepro'),
        'section' => 'bizzbeepro_welcome_section',
        'type'    => 'textarea',
   ) );     
        
     //Our path to Perfection
	 
  $wp_customize->add_setting('show_perfection_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_perfection_section', array(
        'settings' => 'show_perfection_section',
        'label'   => __('Show Perfection Section','bizzbeepro'),
        'section' => 'bizzbeepro_perfection_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => __('Enable','bizzbeepro'),
            '2'=> __('Disable','bizzbeepro'),
        ),
    ));	 
	 
	$wp_customize->add_setting( 'bizzbeepro_perfectiontitle', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_perfectiontitle', array(
		'label'   => __('Perfection Title','bizzbeepro'),
		'section' => 'bizzbeepro_perfection_section',
		'type'    => 'text',
    ) );
	
	 $wp_customize->add_setting( 'bizzbeepro_perfectioninfo', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_perfectioninfo', array(
		'label'   => __('Perfection Info','bizzbeepro'),
        'section' => 'bizzbeepro_perfection_section',
        'type'    => 'textarea',
   ) );
   $wp_customize->add_setting( 'bizzbeepro_perfection_buttontitle', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_perfection_buttontitle', array(
		'label'   => __('Button Title','bizzbeepro'),
		'section' => 'bizzbeepro_perfection_section',
		'type'    => 'text',
    ) );
    
   $wp_customize->add_setting( 'bizzbeepro_perfection_buttonlink', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_url',
	) );
    $wp_customize->add_control( 'bizzbeepro_perfection_buttonlink', array(
		'label'   => __('Button Link','bizzbeepro'),
		'section' => 'bizzbeepro_perfection_section',
		'type'    => 'text',
    ) );
   
	$wp_customize->add_setting( 'bizzbeepro_breadcrumbs_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_breadcrumbs_image_bg', array(
			'label'    => __( 'Background Image (Recommended size 1280 x 853)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_perfection_section',
			'settings' => 'bizzbeepro_breadcrumbs_image_bg',
		) 
	) );   
        
  // Ourteam Section
	$wp_customize->add_setting('show_ourteam_section', array(
		'default'    => '1',
		'type'=>'theme_mod',		
	));
	
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'show_ourteam_section',
			array(
				'label'     => __('Show Our Team Section', 'bizzbeepro'),
				'section'   => 'bizzbeepro_ourteam_section',
				'settings'  => 'show_ourteam_section',
				'type'      => 'checkbox',
			)
		)
	);
  $wp_customize->add_setting('show_ourteam_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_ourteam_section', array(
        'settings' => 'show_ourteam_section',
        'label'   => __('Show Ourteam Section','bizzbeepro'),
        'section' => 'bizzbeepro_ourteam_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => 'Enable',
            '2'=> 'Disable',
        ),
    ));		 
  
   $wp_customize->add_setting( 'bizzbeepro_ourteam_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_ourteam_title', array(
		'label'   => __('Title',''),
		'section' => 'bizzbeepro_ourteam_section',
		'type'    => 'text',
    ) );

    $wp_customize->add_setting( 'bizzbeepro_ourteam_info', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_ourteam_info', array(
		'label'   => __('Short Description','bizzbeepro'),
        'section' => 'bizzbeepro_ourteam_section',
        'type'    => 'textarea',
	) );
	$wp_customize->add_setting( 'bizzbeepro_thumbnail', array(
		'default'        => '',
	) );
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_Welcome_image_bg', array(
			'label'    => __( 'Center Image (Recommended size 420 x 310)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_ourteam_section',
			'settings' => 'bizzbeepro_thumbnail',
		) 
	) );

  // Testimonial Section
    $wp_customize->add_setting('show_testimonial_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_testimonial_section', array(
        'settings' => 'show_testimonial_section',
        'label'   => __('Show Testimonial Section','bizzbeepro'),
        'section' => 'bizzbeepro_testimonial_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => __('Enable','bizzbeepro'),
            '2'=> __('Disable','bizzbeepro'),
        ),
    ));	
   $wp_customize->add_setting( 'bizzbeepro_testimonials_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_testimonials_title', array(
		'label'   => __('Title','bizzbeepro'),
		'section' => 'bizzbeepro_testimonial_section',
		'type'    => 'text',
    ) );
	$wp_customize->add_setting( 'bizzbeepro_testimonial_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_testimonial_image_bg', array(
			'label'    => __( 'Background Image (Recommended size 1280 x 410)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_testimonial_section',
			'settings' => 'bizzbeepro_testimonial_image_bg',
		) 
	) );   	
  
  // Portfolio Section
    $wp_customize->add_setting('show_portfolio_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_portfolio_section', array(
        'settings' => 'show_portfolio_section',
        'label'   => __('Show Portfolio Section','bizzbeepro'),
        'section' => 'bizzbeepro_portfolio_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => __('Enable','bizzbeepro'),
            '2'=> __('Disable','bizzbeepro'),
        ),
    ));  
   $wp_customize->add_setting( 'bizzbeepro_portfolio_title', array(
		'default'        => '',
		'sanitize_callback' => 'esc_attr',
	) );
    $wp_customize->add_control( 'bizzbeepro_portfolio_title', array(
		'label'   => __('Title','bizzbeepro'),
		'section' => 'bizzbeepro_portfolio_section',
		'type'    => 'text',
    ) );

    $wp_customize->add_setting( 'bizzbeepro_portfolio_info', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_portfolio_info', array(
		'label'   => __('Short Description','bizzbeepro'),
        'section' => 'bizzbeepro_portfolio_section',
        'type'    => 'textarea',
	) );
    // Who we are
	$wp_customize->add_setting('show_whoweare_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_whoweare_section', array(
        'settings' => 'show_whoweare_section',
        'label'   => __('Show Who we are Section','bizzbeepro'),
        'section' => 'bizzbeepro_whoweare_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => 'Enable',
            '2'=> 'Disable',
        ),
    ));
    $wp_customize->add_setting( 'bizzbeepro_whoweare_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_whoweare_title', array(
		'label'   => __('Title','bizzbeepro'),
		'section' => 'bizzbeepro_whoweare_section',
		'type'    => 'text',
    ) );
    $wp_customize->add_setting( 'bizzbeepro_whoweare_info', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_whoweare_info', array(
		'label'   => __('Who we are Info','bizzbeepro'),
        'section' => 'bizzbeepro_whoweare_section',
        'type'    => 'textarea',
	) );
	$wp_customize->add_setting( 'bizzbeepro_whoweare_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_whoweare_image_bg', array(
			'label'    => __( 'Background Image', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_whoweare_section',
			'settings' => 'bizzbeepro_whoweare_image_bg',
		) 
	) );
	$wp_customize->add_setting( 'bizzbeepro_whoweare_image',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_whoweare_image', array(
			'label'    => __( 'Right Side Image', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_whoweare_section',
			'settings' => 'bizzbeepro_whoweare_image',
		) 
	) );
    $bizzbeepro_whoweare_subtitle = array();
  $bizzbeepro_whoweare_subtitle[] =  array( 'slug'=>'bizzbeepro_whoweare_subtitle1', 'default' => '', 'label' => esc_html__( 'Sub Title 1', 'bizzbeepro' ),'priority' => '1' );
  $bizzbeepro_whoweare_subtitle[] =  array( 'slug'=>'bizzbeepro_whoweare_subtitle2', 'default' => '', 'label' => esc_html__( 'Sub Title 2', 'bizzbeepro' ),'priority' => '3' );
  $bizzbeepro_whoweare_subtitle[] =  array( 'slug'=>'bizzbeepro_whoweare_subtitle3', 'default' => '', 'label' => esc_html__( 'Sub Title 3', 'bizzbeepro' ),'priority' => '5' );
  foreach($bizzbeepro_whoweare_subtitle as $bizzbeepro_whoweare_subtitles){
    $wp_customize->add_setting(
      $bizzbeepro_whoweare_subtitles['slug'],
      array(
        'default' => '',
        'capability'     => 'edit_theme_options',
        'type' => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
      )
    );
    $wp_customize->add_control(
      $bizzbeepro_whoweare_subtitles['slug'],
      array(
        'type'  => 'text',
        'section' => 'bizzbeepro_whoweare_section',
        //'input_attrs' => array( 'placeholder' => esc_attr__('Enter Icon','bizzbeepro') ),
        'label'      =>   $bizzbeepro_whoweare_subtitles['label'],
        'priority' => $bizzbeepro_whoweare_subtitles['priority']
      )
    );
  }
  $bizzbeepro_whoweare_subdesc = array();
  $bizzbeepro_whoweare_subdesc[] =  array( 'slug'=>'bizzbeepro_whoweare_subdesc1', 'default' => '', 'label' => esc_html__( 'Sub Description 1', 'bizzbeepro' ),'priority' => '1' );
  $bizzbeepro_whoweare_subdesc[] =  array( 'slug'=>'bizzbeepro_whoweare_subdesc2', 'default' => '', 'label' => esc_html__( 'Sub Description 2', 'bizzbeepro' ),'priority' => '3' );
  $bizzbeepro_whoweare_subdesc[] =  array( 'slug'=>'bizzbeepro_whoweare_subdesc3', 'default' => '', 'label' => esc_html__( 'Sub Description 3', 'bizzbeepro' ),'priority' => '5' );
  foreach($bizzbeepro_whoweare_subdesc as $bizzbeepro_whoweare_subdescs){
    $wp_customize->add_setting(
      $bizzbeepro_whoweare_subdescs['slug'],
      array(
        'default' => '',
        'capability'     => 'edit_theme_options',
        'type' => 'theme_mod',
        'sanitize_callback' => 'esc_textarea',
      )
    );
    $wp_customize->add_control(
      $bizzbeepro_whoweare_subdescs['slug'],
      array(
        'type'  => 'textarea',
        'section' => 'bizzbeepro_whoweare_section',
        'priority' => $bizzbeepro_whoweare_subdescs['priority'],
        //'input_attrs' => array( 'placeholder' => esc_html__('Enter URL','bizzbeepro')),
      )
    );
  }

    // end Who we are
   // What You Get
    $wp_customize->add_setting('show_whatyouget_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_whatyouget_section', array(
        'settings' => 'show_whatyouget_section',
        'label'   => __('Show What You Get Section','bizzbeepro'),
        'section' => 'bizzbeepro_whatyouget_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => 'Enable',
            '2'=> 'Disable',
        ),
    ));
   $wp_customize->add_setting( 'bizzbeepro_get_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    $wp_customize->add_control( 'bizzbeepro_get_title', array(
		'label'   => __('Title','bizzbeepro'),
		'section' => 'bizzbeepro_whatyouget_section',
		'type'    => 'text',
    ) );
    
    $wp_customize->add_setting( 'bizzbeepro_get_info', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_get_info', array(
		'label'   => __('What you Get Info','bizzbeepro'),
        'section' => 'bizzbeepro_whatyouget_section',
        'type'    => 'textarea',
	) );
	$wp_customize->add_setting( 'bizzbeepro_youget_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_youget_image_bg', array(
			'label'    => __( 'Right Side Image (Recommended size 570 x 350)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_whatyouget_section',
			'settings' => 'bizzbeepro_youget_image_bg',
		) 
	) ); 
    $wp_customize->add_setting( 'bizzbeepro_get_left_text', array(
		'default'        => '',
		'sanitize_callback' => 'esc_textarea',
	) );
    $wp_customize->add_control( 'bizzbeepro_get_left_text', array(
		'label'   => __('Left Side Text','bizzbeepro'),
        'section' => 'bizzbeepro_whatyouget_section',
        'type'    => 'textarea',
	) );
       
       
     //Blog Section
    $wp_customize->add_setting('show_blog_section', array(
        'default'        => '1',
        'type'           => 'theme_mod',
 
    ));
    $wp_customize->add_control( 'show_blog_section', array(
        'settings' => 'show_blog_section',
        'label'   => __('Show Blog Section','bizzbeepro'),
        'section' => 'bizzbeepro_blog_section',
        'type'    => 'select',
        'choices'    => array(
            '1' => __('Enable',''),
            '2'=> __('Disable',''),
        ),
    ));
	 	 
	$wp_customize->add_setting( 'bizzbeepro_blog_title', array(
		'default'        => '',
		'sanitize_callback' => 'bizzbeepro_sanitize_text',
	) );
    
    $wp_customize->add_control( 'bizzbeepro_blog_title', array(
		'label'   => __('Blog Title','bizzbeepro'),
        'section' => 'bizzbeepro_blog_section',
        'type'    => 'text'
    ) );
    
    $wp_customize->add_setting( 'bizzbeepro_breadcrumbs_blog_image_bg',array(
		'sanitize_callback' => 'esc_attr',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bizzbeepro_breadcrumbs_blog_image_bg', array(
			'label'    => __( 'Background Blog Image (Recommended size 1280 x 853)', 'bizzbeepro' ),
			'section'  => 'bizzbeepro_blog_section',
			'settings' => 'bizzbeepro_breadcrumbs_blog_image_bg',
		) 
	) ); 
        
	$bizzbeepro_args = array(
	'posts_per_page'=> -1,
	'meta_query' => array(
						array(
						'key' => '_thumbnail_id',
						'compare' => 'EXISTS'
							),
						)
					);  
	$bizzbeepro_post = new WP_Query( $bizzbeepro_args );
	$bizzbeepro_cat_id=array();
	while($bizzbeepro_post->have_posts()){
	$bizzbeepro_post->the_post();
	$bizzbeepro_post_categories = wp_get_post_categories( get_the_id());
	foreach($bizzbeepro_post_categories as $bizzbeepro_post_category)
		$bizzbeepro_cat_id[]=$bizzbeepro_post_category;
	}
	
	$bizzbeepro_cat_id=array_unique($bizzbeepro_cat_id);
	$bizzbeepro_args = array(
	'orderby' => 'name',
	'parent' => 0,
	'include'=>$bizzbeepro_cat_id,
	
	);
	$bizzbeepro_cats=array();$i = 0;
	$bizzbeepro_categories = get_categories($bizzbeepro_args); 
	  foreach ($bizzbeepro_categories as $bizzbeepro_category) {
		  if($i==0){
			$bizzbeepro_default = $bizzbeepro_category->term_id;
			$i++;
		}
		$bizzbeepro_cats[$bizzbeepro_category->term_id] =  $bizzbeepro_category->cat_name;
	  }        
      
	 $wp_customize->add_setting( 'bizzbeepro_blogcategory', array(
		'default'        => $bizzbeepro_default,
		'sanitize_callback' => 'esc_attr',
				
	) );
    
    $wp_customize->add_control( 'bizzbeepro_blogcategory', array(
			'label'   => __('Select Category','bizzbeepro'),
            'section' => 'bizzbeepro_blog_section',
            'type'    => 'select',
            'choices' => $bizzbeepro_cats,
        ) );
                
	$wp_customize->add_setting( 'bizzbeepro_metaslider', array(
            'default'        => '',
            'sanitize_callback' => 'bizzbeepro_sanitize_number_absint',
        ) );
    
    $wp_customize->add_control( 'bizzbeepro_metaslider', array(
			'label'   => __('Meta Slider Id','bizzbeepro'),
            'section' => 'bizzbeepro_silder_section',
            'type'    => 'number',
           
        ) );           

}
add_action( 'customize_register', 'bizzbeepro_theme_customizer' );

function bizzbeepro_sanitize_url( $bizzbeepro_url ) {
	return esc_url_raw( $bizzbeepro_url );
}
function bizzbeepro_sanitize_html( $bizzbeepro_html ) {
	return wp_filter_post_kses( $bizzbeepro_html );
}
function bizzbeepro_sanitize_number_absint( $bizzbeepro_number ) {
	// Ensure $number is an absolute integer (whole number, zero or greater).
	$number = absint( $bizzbeepro_number );
	// If the input is an absolute integer, return it; otherwise, return the default
	return ( $bizzbeepro_number ? $bizzbeepro_number : '' );
}
function bizzbeepro_sanitize_text( $bizzbeepro_input ) {
    return wp_kses_post( force_balance_tags( $bizzbeepro_input ) );
}
?>
