<?php
set_time_limit(0);
ini_set('memory_limit', '512M');

$root = __DIR__;
$suspicious_functions = [
    'eval',
    'exec',
    'system',
    'shell_exec',
    'assert',
    'passthru',
    'base64_decode',
    'gzinflate',
    'gzuncompress',
    'str_rot13',
    'create_function',
    'ob_start',
    'preg_replace.*e'
];

echo "<h2>ЁЯЫбя╕П Malware Scanner Report</h2>";
echo "<p>Scanning folder: <strong>" . htmlspecialchars($root) . "</strong></p>";
echo "<hr>";

// This array will hold all suspicious occurrences
$results = [];

/**
 * Scans the given directory recursively for .php files and checks each line for suspicious functions.
 *
 * @param string $dir The directory to scan.
 * @param array $suspicious_functions An array of suspicious functions (as strings or patterns).
 * @param array &$results Reference to the results array to collect findings.
 */
function scanDirectory($dir, $suspicious_functions, &$results) {
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS));
    
    foreach ($iterator as $file) {
        if ($file->isDir()) {
            continue;
        }
        
        $filePath = $file->getPathname();
        // Only scan files with a .php extension (case-insensitive)
        if (strtolower(pathinfo($filePath, PATHINFO_EXTENSION)) !== 'php') {
            continue;
        }
        
        // Read the file into an array of lines; if unable to read, skip the file.
        $lines = @file($filePath);
        if ($lines === false) {
            continue;
        }
        
        foreach ($lines as $line_num => $line) {
            foreach ($suspicious_functions as $func) {
                // If the function string contains a wildcard (like ".*"), use it directly as a regex pattern.
                if (strpos($func, '.*') !== false) {
                    $pattern = '/' . $func . '/i';
                } else {
                    $pattern = '/\b' . preg_quote($func, '/') . '\b/i';
                }
                if (preg_match($pattern, $line)) {
                    $results[] = [
                        'function'    => $func,
                        'file'        => $filePath,
                        'line_number' => $line_num + 1,
                        'line'        => trim($line)
                    ];
                }
            }
        }
    }
}

// Start scanning from the root directory
scanDirectory($root, $suspicious_functions, $results);

// Output the results
if (empty($results)) {
    echo "<p>No suspicious functions were found.</p>";
} else {
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr>
            <th>Suspicious Function</th>
            <th>File</th>
            <th>Line</th>
            <th>Code Snippet</th>
          </tr>";
    foreach ($results as $res) {
        echo "<tr>";
        echo "<td><code>" . htmlspecialchars($res['function']) . "</code></td>";
        echo "<td>" . htmlspecialchars($res['file']) . "</td>";
        echo "<td>" . $res['line_number'] . "</td>";
        echo "<td><code>" . htmlspecialchars($res['line']) . "</code></td>";
        echo "</tr>";
    }
    echo "</table>";
    echo "<p><strong>Total suspicious occurrences found: " . count($results) . "</strong></p>";
}

echo "<p><strong>тЬЕ Scan complete.</strong></p>";
?>
